<?php

/* * ************************************************************
  Nome:        CCRelat
  Descricao:   Script para geracao de relatorios
  de desistencias por fila agrupadas
  Autor:       Leandro N. de Araujo , Renato Nogueira
  Data:        13/07/2011
 * *********************************************************** */

/* * ************************************************************
  Area dos includes
 * *********************************************************** */
$DirRaiz = $_SERVER['DOCUMENT_ROOT'] . '/vdt/';
include_once($DirRaiz . 'config.php');
include_once($DirRaiz . 'config.cc.php');
$Modulo = $DirCCen;
include_once($DirRaiz . $Modulo . $DirClass . 'monitor.class.php');
include_once($DirRaiz . $DirModul . 'geral.modu.php');

/* * ************************************************************
  Definicao de variaveis
 * *********************************************************** */
$Moni = new Monitores;  // Objeto monitor
$L_var = $_POST;         // Recebe as variaveis do formulario


/* * ************************************************************
  Programa Principal
 * *********************************************************** */
$Arquivo = brancos_por_sublinhado($L_var['t'] . ' ' . $L_var['m'] . '.xls');
if ($L_var['tela'] != 'agente')
    $ArquivoExcel = cria_arquivo_excel($Arquivo);
if (isset($L_var['tipoPes']) && $L_var['tipoPes'] != '') {
    $tipoPes = $L_var['tipoPes'];
}

for ($x = 0; $x < $L_var['tg']; $x++)
    $Agentes[$x] = $L_var['g' . $x];
$Imprime = planilha_ligacoes_filas($Agentes, $L_var['d'], $L_var['a'], 'xls', $tipoPes);
echo planilha_ligacoes_filas($Agentes, $L_var['d'], $L_var['a'], 'html', $tipoPes);
if ($ArquivoExcel) {
    fwrite($ArquivoExcel, $Imprime);
    fecha_arquivo_excel($ArquivoExcel);
}

function planilha_ligacoes_filas($Fila, $DataInicio, $DataFim, $Formato, $tipoPesq='relat') {
    global $Moni;
    $dataAtual = date("d/m/Y");
    $hoje = 0;
    $Saida = "";
    list($data, $horario) = explode(' ', $DataInicio);
    if ($data == $dataAtual) $hoje = 1;
    list($dia, $mes, $ano) = explode('/', $data);
    list($hora, $minuto) = explode(':', $horario);
    $DataBancoInicial = $ano . "-" . $mes . "-" . $dia . " " . $hora . ":" . $minuto;
    $DataBancoIQtd = $ano . "-" . $mes . "-" . $dia;

    list($data, $horario) = explode(' ', $DataFim);
    if (($data != $dataAtual) || ($hoje != 1)) {
        return "<b>Erro:</b> <i>Este relatrio permite apenas o perodo do dia atual.</i>";
    }
    list($dia, $mes, $ano) = explode('/', $data);
    list($hora, $minuto) = explode(':', $horario);
    $DataBancoFinal = $ano . "-" . $mes . "-" . $dia . " " . $hora . ":" . $minuto;
    $DataBancoFQtd = $ano . "-" . $mes . "-" . $dia;

    //$Moni->relatorio_desistencia_fila('SUPORTE', $DataBancoInicial, $DataBancoFinal);
    for ($i = 0; $i < count($Fila); $i++) {
        $Tabela = $Moni->relatorio_desistencia_fila($Fila[$i], $DataBancoInicial, $DataBancoFinal, 'hoje', 'monit');
        //return $Tabela;
        if ($Formato == "html") {
            $Saida.= '<p class="reltit">Relatrio de Desistncias Acumuldadas da Fila ';
            $Saida.= $Fila[$i] . '</p>';
            $Saida.='<p class="relper">Perodo: &nbsp;&nbsp;' . $DataInicio . ' >>> ' . $DataFim . '</p>';
        } else if ($Formato == "xls") {
            $Saida .= '<table x:str border=0 cellpadding=0 cellspacing=0 style="border-collapse: collapse;table-layout:fixed;">';
            $Saida .= '<tr><td class="xl24" width=100 colspan="3">';
            $Saida .= 'Relat&oacute;rio de desist&ecirc;ncias na fila <b>' . $Fila[$i] . '</b>';
            $Saida .= '</td></tr><tr><td class="xl24" width="100" colspan="3">';
            $Saida .= 'Per&iacute;odo: &nbsp;&nbsp;<b>' . $DataInicio . '</b>&nbsp;&nbsp;&nbsp;>>>&nbsp;&nbsp;&nbsp;' . $DataFim;
            $Saida .= '</td></tr>';
        }
        $Saida.= monta_relatorio_fila_desistencia_acumulada($Tabela, $Formato);
    }
    return $Saida;
}

function monta_relatorio_fila_desistencia_acumulada($Dados, $Formato='html') {
    global $Moni;
    $Saida = "";
    if ($Formato=="html") $Saida .= '<table class="relat"><tr><td class="relatT" colspan=2>';
    if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>';
    $Saida .= 'Chamadas no atendidas por dia</td></tr>';
    $Cor = "#FFFFFF";
    foreach($Dados as $Data => $Array1){
        if($Data != ''){
            if ($Formato=="html") $Saida .= '<tr><td class="relatT" colspan=2>';
            if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>';
            $Saida .= $Data.'</td></tr>';
            if ($Formato=="html") $Saida .= '<tr><td class="relatT">';
            if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>';
            $Saida .= 'N&uacute;mero</td>';
            if ($Formato=="html") $Saida .= '<td class="relatT">';
            if ($Formato=="xls")  $Saida .= '<td class=xl24 width=64>';
            $Saida .= 'Quantidade</td></tr>';
            foreach($Array1 as $Numero => $Quant){
                ($Cor == "#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
                if ($Formato=="html") $Saida .= '<tr><td class="relatT" style="background-color:'.$Cor.';">';
                if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>';
                $Saida .= $Numero.'</td>';
                if ($Formato=="html") $Saida .= '<td class="relatT" style="background-color:'.$Cor.';">';
                if ($Formato=="xls")  $Saida .= '<td class=xl24 width=64>';
                $Saida .= $Quant['Quantidade'].'</td></tr>';
            }
            if ($Formato=="html") $Saida .= '<tr><td class="relatT" colspan=2>';
            if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>';
            $Saida .= '&nbsp;</td></tr>';
        }
    }
    $Saida .= '</table><br/><br/>';
    return $Saida;
}

?>
